import React, { Component } from 'react';
import InfiniteCarousel from 'react-leaf-carousel';
import { withStyles } from '@material-ui/core/styles';
import styles from './styles';

type Props = {
    language: string,
    classes: {
        [key: string]: string
    },
    className: object,
    slidingTime: number,
    children: ReactElement
};

const SHOW_SIDES = true;
const AUTO_CYCLE = true;
const DISABLE_SWIPE_EVENTS = true;

class SlidingFooter extends Component<Props> {
    constructor(props) {
        super(props);
        this.state = {
            language: props.language,
            languageChanged: false
        };
    }

    static getDerivedStateFromProps(nextProps, prevState) {
        const { language } = nextProps;
        if (prevState.language !== language) {
            return { language, languageChanged: true };
        }
        return null;
    }

    componentDidUpdate(prevProps, prevState) {
        // Adding this hack here as carousel doesn't updating itself
        // This way we are destroying it and trying to re-create
        const { languageChanged } = this.state;
        if (!prevState.languageChanged && languageChanged) {
            setTimeout(() => {
                this.setState({ languageChanged: false });
            }, 50);
        }
    }

    render() {
        const { classes, className, slidingTime, children } = this.props;
        const { languageChanged } = this.state;
        return (
            <div className={[classes.container, className || ''].join(' ')}>
                {!languageChanged && (
                    <InfiniteCarousel
                        breakpoints={[
                            {
                                breakpoint: 1,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1
                                }
                            }
                        ]}
                        dots={false}
                        showSides={SHOW_SIDES}
                        sidesOpacity={0.5}
                        sideSize={1}
                        slidesToScroll={1}
                        slidesToShow={1}
                        scrollOnDevice={false}
                        swipe={false}
                        pauseOnHover={false}
                        autoCycle={AUTO_CYCLE}
                        cycleInterval={slidingTime || 8000}
                        nextArrow={<div className={classes.rightFooterPart} />}
                        prevArrow={<div className={classes.leftFooterPart} />}
                        disableSwipeEvents={DISABLE_SWIPE_EVENTS}
                    >
                        {React.Children.map(children, child => (
                            <div className={classes.item}>{child}</div>
                        ))}
                    </InfiniteCarousel>
                )}
            </div>
        );
    }
}

export default withStyles(styles)(SlidingFooter);
